/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.webhook.github.event_handler.GitHubAppAuthorizationEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubAppInstallationEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubCheckRunEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubCommitStatusEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubNoOpWebhookEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubPullRequestEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubPushEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubRepositoriesInstallationEventHandler;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import com.teamscale.service.webhook.github.event_handler.IMergeRequestUpdateTriggerSchedulingHelper;

public class GitHubWebhookEventHandlerFactory {
    public static GitHubWebhookEventHandlerBase create(String event, IndexLayer indexLayer, String gitHubServerUrl, IMergeRequestUpdateTriggerSchedulingHelper schedulingHelper) {
        return switch (event) {
            case "installation" -> new GitHubAppInstallationEventHandler(indexLayer, gitHubServerUrl);
            case "installation_repositories" -> new GitHubRepositoriesInstallationEventHandler(indexLayer);
            case "github_app_authorization" -> new GitHubAppAuthorizationEventHandler(indexLayer);
            case "push" -> new GitHubPushEventHandler(indexLayer);
            case "pull_request" -> new GitHubPullRequestEventHandler(indexLayer, schedulingHelper);
            case "check_run" -> new GitHubCheckRunEventHandler(indexLayer, schedulingHelper);
            case "status" -> new GitHubCommitStatusEventHandler(indexLayer, schedulingHelper);
            default -> new GitHubNoOpWebhookEventHandler(indexLayer);
        };
    }
}

