/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class TtlDB
extends RocksDB {
    public static TtlDB open(Options options, String db_path) throws RocksDBException {
        return TtlDB.open(options, db_path, 0, false);
    }

    public static TtlDB open(Options options, String db_path, int ttl, boolean readOnly) throws RocksDBException {
        return new TtlDB(TtlDB.open(options.nativeHandle_, db_path, ttl, readOnly));
    }

    public static TtlDB open(DBOptions options, String db_path, List<ColumnFamilyDescriptor> columnFamilyDescriptors, List<ColumnFamilyHandle> columnFamilyHandles, List<Integer> ttlValues, boolean readOnly) throws RocksDBException {
        if (columnFamilyDescriptors.size() != ttlValues.size()) {
            throw new IllegalArgumentException("There must be a ttl value per column family handle.");
        }
        byte[][] cfNames = new byte[columnFamilyDescriptors.size()][];
        long[] cfOptionHandles = new long[columnFamilyDescriptors.size()];
        for (int i = 0; i < columnFamilyDescriptors.size(); ++i) {
            ColumnFamilyDescriptor cfDescriptor = columnFamilyDescriptors.get(i);
            cfNames[i] = cfDescriptor.getName();
            cfOptionHandles[i] = cfDescriptor.getOptions().nativeHandle_;
        }
        int[] ttlVals = new int[ttlValues.size()];
        for (int i = 0; i < ttlValues.size(); ++i) {
            ttlVals[i] = ttlValues.get(i);
        }
        long[] handles = TtlDB.openCF(options.nativeHandle_, db_path, cfNames, cfOptionHandles, ttlVals, readOnly);
        TtlDB ttlDB = new TtlDB(handles[0]);
        for (int i = 1; i < handles.length; ++i) {
            columnFamilyHandles.add(new ColumnFamilyHandle(ttlDB, handles[i]));
        }
        return ttlDB;
    }

    @Override
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TtlDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TtlDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    public ColumnFamilyHandle createColumnFamilyWithTtl(ColumnFamilyDescriptor columnFamilyDescriptor, int ttl) throws RocksDBException {
        return new ColumnFamilyHandle(this, this.createColumnFamilyWithTtl(this.nativeHandle_, columnFamilyDescriptor.getName(), columnFamilyDescriptor.getOptions().nativeHandle_, ttl));
    }

    protected TtlDB(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected native void disposeInternal(long var1);

    private static native long open(long var0, String var2, int var3, boolean var4) throws RocksDBException;

    private static native long[] openCF(long var0, String var2, byte[][] var3, long[] var4, int[] var5, boolean var6) throws RocksDBException;

    private native long createColumnFamilyWithTtl(long var1, byte[] var3, long var4, int var6) throws RocksDBException;

    private static native void closeDatabase(long var0) throws RocksDBException;
}

