/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkDataStorage;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class SimulinkDataDictionary
extends SimulinkDataStorage {
    private static final long serialVersionUID = 1L;
    private final List<String> subDataDictionaries;
    private final @Nullable String uniformPath;

    public SimulinkDataDictionary(Set<ISimulinkDataDictionaryEntry> entries, List<String> subDataDictionaries, @Nullable String uniformPath) {
        super(entries);
        this.subDataDictionaries = Collections.unmodifiableList(subDataDictionaries);
        this.uniformPath = uniformPath;
    }

    public boolean containsEntry(String name) {
        return this.entries.get(name) != null;
    }

    public List<SimulinkBus> getBuses() {
        return this.entries.values().stream().filter(entry -> entry instanceof SimulinkBus).map(bus -> (SimulinkBus)bus).collect(Collectors.toList());
    }

    public List<String> getSubDataDictionaries() {
        return this.subDataDictionaries;
    }

    public @Nullable String getUniformPath() {
        return this.uniformPath;
    }

    public String buildLineBasedRepresentation() {
        StringBuilder representation = new StringBuilder();
        for (ISimulinkDataDictionaryEntry entry : this.getEntries()) {
            representation.append(entry.getName());
            representation.append(": ");
            representation.append(entry.getEntryType());
            representation.append("\n");
        }
        return representation.toString();
    }
}

