/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimulinkRegistry {
    private static final SimulinkRegistry INSTANCE = new SimulinkRegistry();
    private static final String DEFAULT_SIMULINK_BLOCK_LOOKUP_FILE = "simulink-blocks/default_blockLabelLookupMap.xml";
    private static final String USER_SIMULINK_BLOCK_LOOKUP_FILE = "simulink-blocks/user_blockLabelLookupMap.xml";
    private static final String BLOCK_TAG = "block";
    private static final String TYPE_TAG = "type";
    private static final String PARAMETER_TAG = "parameter";
    private static final String TEXT_TAG = "text";
    private static final String ICON_TAG = "icon";
    private final Map<String, String> labelTextLookup = new HashMap<String, String>();
    private final Map<String, String> labelParameterLookup = new HashMap<String, String>();
    private final Map<String, String> labelIconLookup = new HashMap<String, String>();
    private static final Logger LOGGER = LogManager.getLogger();

    private SimulinkRegistry() {
        Class<SimulinkRegistry> contextClass = SimulinkRegistry.class;
        InputSource blockLookupSource = new InputSource(Resource.of(contextClass, (String)DEFAULT_SIMULINK_BLOCK_LOOKUP_FILE).getAsStream());
        this.loadSimulinkSource(blockLookupSource);
        blockLookupSource = new InputSource(Resource.of(contextClass, (String)USER_SIMULINK_BLOCK_LOOKUP_FILE).getAsStream());
        this.loadSimulinkSource(blockLookupSource);
    }

    public static SimulinkRegistry getInstance() {
        return INSTANCE;
    }

    private void loadSimulinkSource(InputSource textLookupSource) {
        try {
            NodeList lookupNodes = XMLUtils.parse((InputSource)textLookupSource).getElementsByTagName(BLOCK_TAG);
            for (Element blockElement : XMLUtils.elementNodes((NodeList)lookupNodes)) {
                String blockType = XMLUtils.getNamedChildContent((Element)blockElement, (String)TYPE_TAG);
                SimulinkRegistry.populateLookupMap(blockType, blockElement, PARAMETER_TAG, this.labelParameterLookup);
                SimulinkRegistry.populateLookupMap(blockType, blockElement, TEXT_TAG, this.labelTextLookup);
                SimulinkRegistry.populateLookupMap(blockType, blockElement, ICON_TAG, this.labelIconLookup);
            }
        }
        catch (IOException | SAXException e) {
            LOGGER.error((Object)e);
        }
    }

    private static void populateLookupMap(String blockType, Element blockElement, String xmlTagName, Map<String, String> lookupMap) {
        String lookupValue = XMLUtils.getNamedChildContent((Element)blockElement, (String)xmlTagName);
        if (!StringUtils.isEmpty((String)lookupValue)) {
            lookupMap.put(blockType, lookupValue);
        }
    }

    public String getLabelText(String type) {
        return this.labelTextLookup.get(type);
    }

    public String getLabelParameter(String typeString) {
        return this.labelParameterLookup.get(typeString);
    }

    public String getLabelIcon(String typeString) {
        return this.labelIconLookup.get(typeString);
    }
}

