/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ReferencedBlockInfo;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.ESimulinkBlockType;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.ui.SimulinkAnnotationUIData;
import org.conqat.lib.simulink.ui.SimulinkLabelOnBlockData;
import org.conqat.lib.simulink.ui.SimulinkLineUIData;
import org.conqat.lib.simulink.ui.SimulinkPortUIData;
import org.conqat.lib.simulink.ui.SimulinkUiDataBase;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;

public class SimulinkBlockUIData
extends SimulinkUiDataBase {
    private static final String TYPE_PROPERTY = "type";
    private static final String SOURCE_TYPE_PROPERTY = "sourceType";
    private static final String INNER_LABEL_DATA_PROPERTY = "innerLabelData";
    private static final String LABEL_DATA_PROPERTY = "labelData";
    private static final String LAYOUT_DATA_PROPERTY = "layoutData";
    private static final String SUB_LABEL_DATA_PROPERTY = "subLabelData";
    private static final String LABEL_ON_BLOCK_PROPERTY = "labelOnBlock";
    @JsonProperty(value="type")
    private final ESimulinkBlockType type;
    @JsonProperty(value="sourceType")
    private final @Nullable String sourceType;
    @JsonProperty(value="innerLabelData")
    private final @Nullable LabelLayoutData innerLabelData;
    @JsonProperty(value="labelData")
    private final LabelLayoutData labelData;
    @JsonProperty(value="layoutData")
    private final BlockLayoutData layoutData;
    @JsonProperty(value="subLabelData")
    private final @Nullable LabelLayoutData subLabelData;
    @JsonProperty(value="subBlocks")
    private final List<SimulinkBlockUIData> subBlocks = new ArrayList<SimulinkBlockUIData>();
    @JsonProperty(value="inPorts")
    private final List<SimulinkPortUIData> inPorts = new ArrayList<SimulinkPortUIData>();
    @JsonProperty(value="outPorts")
    private final List<SimulinkPortUIData> outPorts = new ArrayList<SimulinkPortUIData>();
    @JsonProperty(value="annotations")
    private final List<SimulinkAnnotationUIData> annotations = new ArrayList<SimulinkAnnotationUIData>();
    @JsonProperty(value="labelOnBlock")
    private final SimulinkLabelOnBlockData labelOnBlock;
    @JsonProperty(value="containedLines")
    private final List<SimulinkLineUIData> containedLines = new ArrayList<SimulinkLineUIData>();
    @JsonProperty(value="reference")
    private @Nullable ReferenceUiData reference = null;

    @JsonCreator
    public SimulinkBlockUIData(@JsonProperty(value="name") String name, @JsonProperty(value="qualifiedName") String qualifiedName, @JsonProperty(value="type") ESimulinkBlockType type, @JsonProperty(value="sourceType") @Nullable String sourceType, @JsonProperty(value="innerLabelData") @Nullable LabelLayoutData innerLabelData, @JsonProperty(value="labelData") LabelLayoutData labelData, @JsonProperty(value="layoutData") BlockLayoutData layoutData, @JsonProperty(value="subLabelData") @Nullable LabelLayoutData subLabelData, @JsonProperty(value="labelOnBlock") SimulinkLabelOnBlockData labelOnBlock) {
        super(name, qualifiedName);
        this.type = type;
        this.sourceType = sourceType;
        this.innerLabelData = innerLabelData;
        this.labelData = labelData;
        this.layoutData = layoutData;
        this.subLabelData = subLabelData;
        this.labelOnBlock = labelOnBlock;
    }

    public SimulinkBlockUIData(SimulinkBlock block, IModelResolver modelResolver, Predicate<String> treatLibraryAsBasicBlock, SimulinkPropagatedSignalLabels propagatedSignalLabels, SimulinkResolvedDataTypes propagatedDataTypes) {
        this(block, modelResolver, treatLibraryAsBasicBlock, propagatedSignalLabels, propagatedDataTypes, true);
    }

    private SimulinkBlockUIData(SimulinkBlock block, IModelResolver modelResolver, Predicate<String> treatLibraryAsBasicBlock, SimulinkPropagatedSignalLabels propagatedSignalLabels, SimulinkResolvedDataTypes propagatedDataTypes, boolean provideSubBlocks) {
        super(block.getNameUnescapeNewLineChars(), block.getId());
        this.type = SimulinkUtils.determineBlockType(block);
        this.sourceType = block.getSourceType();
        this.labelData = block.obtainLabelLayoutData();
        this.layoutData = block.obtainBlockLayoutData();
        this.subLabelData = block.obtainSubLabelData();
        this.addContainedLines(block, propagatedSignalLabels, propagatedDataTypes);
        this.addAnnotations(block);
        if (provideSubBlocks) {
            this.addSubBlocks(block, modelResolver, treatLibraryAsBasicBlock, propagatedSignalLabels, propagatedDataTypes);
        }
        this.addPorts(block);
        this.addReferenceInfo(block, modelResolver, treatLibraryAsBasicBlock);
        this.innerLabelData = block.obtainInnerLabelData();
        this.labelOnBlock = new SimulinkLabelOnBlockData(block, this.type);
    }

    private void addReferenceInfo(SimulinkBlock block, IModelResolver modelResolver, Predicate<String> treatLibraryAsBasicBlock) {
        ReferencedBlockInfo referenceInfo = block.getReferencedBlockInfo();
        if (referenceInfo != null) {
            if (treatLibraryAsBasicBlock.test(referenceInfo.getBlockName())) {
                block.setParameter("MaskDisplayString", StringUtils.getLastPart((String)referenceInfo.getBlockName(), (String)"/"));
            } else {
                String modelPath = modelResolver.resolveModelPath(referenceInfo.getModelName(), referenceInfo.getBlockName(), referenceInfo.isSubsystemReference());
                Optional<SimulinkBlock> referencedBlock = block.resolveReferencedBlock();
                ESimulinkBlockType referencedBlockType = referencedBlock.map(SimulinkUtils::determineBlockType).orElse(null);
                this.reference = new ReferenceUiData(modelPath, referenceInfo.getBlockName(), referencedBlockType);
            }
        }
    }

    private void addPorts(SimulinkBlock block) {
        for (SimulinkInPort inPort : block.getInPorts()) {
            this.inPorts.add(new SimulinkPortUIData(inPort));
        }
        for (SimulinkOutPort outPort : block.getOutPorts()) {
            this.outPorts.add(new SimulinkPortUIData(outPort));
        }
    }

    private void addSubBlocks(SimulinkBlock block, IModelResolver modelResolver, Predicate<String> treatLibraryAsBasicBlock, SimulinkPropagatedSignalLabels propagatedSignalLabels, SimulinkResolvedDataTypes propagatedDataTypes) {
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            this.subBlocks.add(new SimulinkBlockUIData(subBlock, modelResolver, treatLibraryAsBasicBlock, propagatedSignalLabels, propagatedDataTypes, false));
        }
    }

    private void addContainedLines(SimulinkBlock block, SimulinkPropagatedSignalLabels propagatedSignalLabels, SimulinkResolvedDataTypes propagatedDataTypes) {
        for (SimulinkLine line : block.getContainedLines()) {
            this.containedLines.add(new SimulinkLineUIData(line, propagatedSignalLabels, propagatedDataTypes));
        }
    }

    private void addAnnotations(SimulinkBlock block) {
        for (SimulinkAnnotation annotation : block.getAnnotations()) {
            this.annotations.add(new SimulinkAnnotationUIData(annotation));
        }
    }

    public ESimulinkBlockType getType() {
        return this.type;
    }

    public LabelLayoutData getBlockInnerLabelData() {
        return this.innerLabelData;
    }

    public LabelLayoutData getBlockLabelData() {
        return this.labelData;
    }

    public BlockLayoutData getBlockLayoutData() {
        return this.layoutData;
    }

    public LabelLayoutData getBlockSubLabelData() {
        return this.subLabelData;
    }

    public List<SimulinkBlockUIData> getSubBlocks() {
        return this.subBlocks;
    }

    public List<SimulinkPortUIData> getInPorts() {
        return this.inPorts;
    }

    public List<SimulinkPortUIData> getOutPorts() {
        return this.outPorts;
    }

    public List<SimulinkAnnotationUIData> getAnnotations() {
        return this.annotations;
    }

    public List<SimulinkLineUIData> getContainedLines() {
        return this.containedLines;
    }

    public SimulinkLabelOnBlockData getLabelOnBlock() {
        return this.labelOnBlock;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public ReferenceUiData getReference() {
        return this.reference;
    }

    public static class ReferenceUiData {
        private static final String PATH_PROPERTY = "path";
        private static final String ID_PROPERTY = "id";
        private static final String REFERENCED_BLOCK_TYPE_PROPERTY = "referencedBlockType";
        @JsonProperty(value="path")
        public final String path;
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="referencedBlockType")
        public final ESimulinkBlockType referencedBlockType;

        @JsonCreator
        public ReferenceUiData(@JsonProperty(value="path") String path, @JsonProperty(value="id") String id, @JsonProperty(value="referencedBlockType") ESimulinkBlockType referencedBlockType) {
            this.path = path;
            this.id = id;
            this.referencedBlockType = referencedBlockType;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }
    }

    @FunctionalInterface
    public static interface IModelResolver {
        public String resolveModelPath(String var1, String var2, boolean var3);
    }
}

