/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import java.nio.ByteBuffer;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;

public class ByteBufferByteIterable
implements ByteIterable {
    @NotNull
    private final ByteBuffer buffer;
    private final int length;

    public ByteBufferByteIterable(@NotNull ByteBuffer buffer) {
        this(buffer.slice(), buffer.remaining());
    }

    private ByteBufferByteIterable(@NotNull ByteBuffer buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    @Override
    public ByteIterator iterator() {
        final ByteBuffer copy = this.buffer.slice();
        return new ByteIterator(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ByteBufferByteIterable.this.length;
            }

            @Override
            public byte next() {
                return copy.get(this.index++);
            }

            @Override
            public long skip(long bytes) {
                int result = (int)Math.min(bytes, (long)(ByteBufferByteIterable.this.length - this.index));
                this.index += result;
                return result;
            }
        };
    }

    @Override
    public byte[] getBytesUnsafe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        ByteBuffer copy = this.buffer.slice();
        copy.position(offset).limit(Math.min(this.buffer.limit(), offset + length));
        return new ByteBufferByteIterable(copy, length);
    }

    @Override
    public int compareTo(@NotNull ByteIterable right) {
        if (right instanceof ByteBufferByteIterable) {
            return this.buffer.compareTo(((ByteBufferByteIterable)right).buffer);
        }
        return ByteIterableUtil.compare(this, right);
    }
}

