/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.metrics;

import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class PrometheusMetricsInterceptor
implements Interceptor {
    private static final Counter OUTGOING_REQUESTS_COUNTER = (Counter)((Counter.Builder)((Counter.Builder)Counter.builder().labelNames(new String[]{"request_url"})).help("Number of outgoing requests per request URL target. By default, the URL only reflects the hostname to keep dimensions of this metric small. Can be adjusted using a JVM flag.")).name("outgoing_rest_requests").register();
    private static final String URL_REGEX = System.getProperty("com.teamscale.rest.prometheus-url-matcher", "");
    private static final Pattern URL_MATCHER = Pattern.compile(URL_REGEX);

    public @NonNull Response intercept(Interceptor.Chain chain) throws IOException {
        Matcher matcher;
        String requestUrl = chain.request().url().host();
        if (!StringUtils.isEmpty((String)URL_REGEX) && (matcher = URL_MATCHER.matcher(chain.request().url().toString())).matches() && matcher.groupCount() == 1) {
            requestUrl = matcher.group(1);
        }
        ((CounterDataPoint)OUTGOING_REQUESTS_COUNTER.labelValues(new String[]{requestUrl})).inc();
        return chain.proceed(chain.request());
    }
}

