Dynamic typing should not be used, except for overridden methods or attributes.

# Why is This a Problem?

When the `Dynamic` keyword appears the system will postpone type checking from compile time to runtime. 
This can make the code harder to understand and introduce type-related issues that may only be discovered at runtime.
It also reduces the ability of static code analysis tools to catch type mismatches and other errors.

# How Can I Resolve This?

One option is to use static typing, which provides benefits such as improved type safety and better tooling support.
In some cases, using polymorphism or interfaces can be a better approach to achieving the desired functionality.