This check flags repetitive DML statements.

# Why is This a Problem?
Frequent context switches between PL/SQL and SQL during repetitive DML operations are inefficient.
Using BULK operations minimizes these switches by executing multiple statements in a single call, improving performance.

# How Can I Resolve This?
Prefer using bulk operations (BULK COLLECT, FORALL) whenever you have to execute a DML statement for more than 4 times.

# Examples
## Non-Compliant

```oraclesqlplus
declare
    t_employee_ids   employee_api.t_employee_ids_type;
    co_increase      constant employees.salary%type          := 0.1;
    co_department_id constant departments.department_id%type := 10;
begin
    t_employee_ids := employee_api.employee_ids_by_department(
            id_in => co_department_id
                      );
    <<process_employees>>
    for i in 1..t_employee_ids.count()
        loop
            update employees
            set salary = salary + (salary * co_increase)
            where employee_id = t_employee_ids(i);
        end loop process_employees;
end;
/

```

## Compliant

```oraclesqlplus
declare
    t_employee_ids   employee_api.t_employee_ids_type;
    co_increase      constant employees.salary%type          := 0.1;
    co_department_id constant departments.department_id%type := 10;
begin
    t_employee_ids := employee_api.employee_ids_by_department(
            id_in => co_department_id
                      );
    <<process_employees>>
        forall i in 1..t_employee_ids.count()
        update employees
        set salary = salary + (salary * co_increase)
        where employee_id = t_employee_ids(i);
end;
/
```


# Where Can I Learn More?
- [G-3210: Always use BULK OPERATIONS (BULK COLLECT, FORALL) whenever you have to execute a DML statement for more than 4 times](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.2/4-language-usage/3-dml-and-sql/2-bulk-operations/g-3210/)


