# Rule 17.7 The value returned by a function having non-*void* return type shall be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
It is possible to call a function without using the return value, which may be an error. If the return value
of a function is intended not to be used explicitly, it should be cast to the *void* type. This has the effect
of using the value without violating Rule 2.2.

## Example
```c
uint16_t func ( uint16_t para1 )
{
 return para1;
}
uint16_t x;
void discarded ( uint16_t para2 )
{
 func ( para2 ); /* Non-compliant - value discarded */
 ( void ) func ( para2 ); /* Compliant */
 x = func ( para2 ); /* Compliant */
}
```

## See also
Dir 4.7, Rule 2.2

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
