# Rule 2.4 A project should not contain unused tag declarations

## Category

Advisory

## Analysis

Decidable, System

## Applies to

C90, C99, C11

## Rationale

If a tag is declared but not used, then it is unclear to a reviewer if the tag is redundant or it has been left unused by mistake.

## Example

In the following example, the tag state is unused and the declaration could have been written without it.

```c
void unusedtag (void)
{
    enum state { Sinit, S_run, Ssleep }; /* Non-compliant */
}

```

In the following example, the tag `record_t` is used only in the typedef of `record1_t` which is used in the rest of the translation unit whenever the type is needed. This typedef can be written in a compliant manner by omitting the tag as shown in the definition of `record2_t`.

```c
typedef struct record_t
{
    uint16_t key;
    uint16_t val;
} record1_t; /* Non-compliant */

typedef struct
{
    uint16_t key;
    uint16_t val;
} record2_t; /* Compliant */

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
