# Rule 20.14 All #else, #elif and #endif preprocessor directives shall reside in the same file as the #if, #ifdef or #ifndef directive to which they are related
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
Confusion can arise when blocks of code are included or excluded by the use of conditional compilation directives which are spread over multiple files. Requiring that a *#if* directive be terminated within the same file reduces the visual complexity of the code and the chance that errors will be made during maintenance.
Note: *#if* directives may be used within included files provided they are terminated within the same file.
## Example
```c
/* file1.c */
#ifdef A /* Compliant */
#include "file1.h"
#endif
/* End of file1.c */

/* file2.c */
#if 1 /* Non-compliant */
#include "file2.h"
/* End of file2.c*/

/* file1.h */
#if 1 /* Compliant */
#endif
/* End of file1.h */

/* file2.h */
#endif
/* End of file2.h */
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
