# Rule 21.15 The pointer arguments to the Standard Library functions memcpy, memmove and memcmp shall be pointers to qualified or unqualified versions of compatible types
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
The Standard Library functions
`void * memcpy ( void * restrict s1, const void * restrict s2, size_t n );`
`void * memmove ( void *s1, const void *s2, size_t n );`
`int memcmp ( const void *s1, const void *s2, size_t n );`
perform a byte by byte copy, move or comparison of the first `n` bytes of the two objects pointed at by `s1` and `s2`.
An attempt to call one of these functions with arguments which are pointers to different types may indicate a mistake.
## Example
```c
/*
 * Is it intentional to only copy part of 's2'?
 */
void f ( uint8_t s1[ 8 ], uint16_t s2[ 8 ] )
{
 ( void ) memcpy ( s1, s2, 8 ); /* Non-compliant */
}
```
## See also
Rule 21.14, Rule 21.16

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
