# Rule 22.20 Thread-specific storage pointers shall be created before being accessed

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C11

## Amplification
Objects of type *tss_t* shall be explicitly created by *tss_create()* before being accessed.

## Rationale
Thread-specific storage pointers have to be explicitly created before accessing them. Creating them
inside of threads creates dependencies on thread execution and ordering which are hard to
maintain and check. Creating them before creating the threads accessing them is a deterministic way
to prevent threads from accessing thread-specific storage pointers with indeterminate state.

## Example
```c
tss_t key1;
tss_t key2;
thrd_t id1;
thrd_t id2;
int32_t g1;
int32_t g2;

int32_t t2( void *ignore ) /* Thread t2 entry */
{
 tss_create( &key1, NULL ); /* Non-compliant - thread t1 might already have
 tried to access key1 */
}

int32_t t1( void *ignore ) /* Thread t1 entry */
{
 tss_set ( key1, &g1 ); /* Non-compliant - might not yet be created */
 tss_set ( key2, &g2 ); /* Compliant */
 int32_t *v1 = tss_get( key1 );
 int32_t *v2 = tss_get( key2 );
 *v1 = computeG1();
 *v2 = computeG2();
}

void main( void )
{
 int32_t i;
 tss_create( &key2, NULL ); /* Compliant */

 thrd_create( &id1, t1, NULL );
 thrd_create( &id2, t2, NULL );

}
```

## See also
Dir 4.13

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
