# Rule 23.3 A generic selection should contain at least one non-default association

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Amplification
A generic selection should contain at least one association which explicitly specifies an object type.
The presence of a default association is always optional.

## Rationale
A generic selection that consists only of a usable default association does not do anything useful;
the default association's result value is evaluated unconditionally.

Omitting a default association indicates intent to check the operand type, by introducing a constraint
violation when the type does not match.

## Example
```c
/* Non-compliant - consists only of a default association */
#define no_op(X) _Generic( (X), default: (X) )

/* Compliant - has a non-default and a default association */
#define filter_ints(X) ( _Generic( (X) \
 , int32_t: handle_int \
 , default: handle_numeric_value ) (X) )

/* Compliant - has non-default associations */
#define only_ints(X) ( _Generic( (X) \
 , int32_t: handle_int \
 , uint32_t: handle_int ) (X) )
```

The following example demonstrates that, by omitting a default association, there is a clear intent to
check the operand type, by introducing a constraint violation when the type does not match:
```c
/* Compliant - it has a single permitted type and is
 intended to prevent implicit conversion */
#define require_char(X) ( _Generic ( (X), char8_t: (X) ) )
```

## See also
Rule 23.4, Rule 23.8

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
