# Rule 7.4 A string literal shall not be assigned to an object unless the object's type is "pointer to const-qualified char"

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Amplification

The type used to represent characters within a string literal depends on the encoding prefix:
* `char` when there is no prefix - character string literal;
* `char` for a `u8` prefix - UTF-8 string literal;
* `wchar_t` for an `L` prefix wide string literal;
* `char16_t` for a `u` prefix - wide string literal;
* `char32_t` for a `u` prefix - wide string literal.

No attempt shall be made to directly modify a character string literal, a UTF-8 string literal or a wide string literal.

The result of the address-of operator, `&`, applied to a character string literal or a UTF-8 string literal shall not be assigned to an object unless that object's type is "pointer to array of const-qualified char".

The result of the address-of operator, `&`, applied to a wide string literal shall not be assigned to an object unless that object's type is "pointer to array of const-qualified wchar_t", "pointer to array of const-qualified char16_t" or "pointer to array of const-qualified char32_t", as appropriate for the encoding prefix. 

## Rationale

Any attempt to modify a string literal results in undefined behaviour. For example, some implementations may store string literals in read-only memory in which case an attempt to modify the string literal will fail and may also result in an exception or crash. This rule, when applied in conjunction with others, prevents a string literal from being modified.

It is explicitly unspecified in C99 and later whether string literals that share a common ending are stored in distinct memory locations. Therefore, even if an attempt to modify a string literal appears to succeed, it is possible that another string literal might be inadvertently altered. 

## Exception

This rule does not apply to a string literal passed as an argument to the variable argument list of a variadic function. 

## Example

The following example shows an attempt to modify a string literal directly:

```c
"0123456789"[0] = '*'; /* Non-compliant */

```

These examples show how to prevent modification of string literals indirectly:

```c
char *s = "string"; /* Non-compliant - s is not const-qualified */
const volatile char *p = "string"; /* Compliant - p is const-qualified; additional qualifiers are permitted */

extern void f1 (char *s1);
extern void f2 (const char *s2);

void g (void)
{
    f1 ("string"); /* Non-compliant - parameter s1 is not const-qualified */
    f2 ("string"); /* Compliant */
}

char *name1 (void)
{
    return ("MISRA"); /* Non-compliant - return type is not const-qualified */
}

const char *name2 (void)
{
    return ("MISRA"); /* Compliant */
}

```

This example shows the permitted exemption for variadic functions:

```c
extern void f3 (uint16_t x, ...); /* Note: non-compliant with Rule 17.1 */
extern void f4 (char *text, ...); /* Note: non-compliant with Rule 17.1 */

void variadic (void)
{
    f3 (42u, "MISRA"); /* Compliant by exception */
    f4 ("MISRA", 42u); /* Non-compliant - exception only applies to variable argument lists */
}

```

## See also

Rule 11.4, Rule 11.8, Rule 17.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
