# Rule 9.7 Atomic objects shall be appropriately initialized before being accessed

## Category

Mandatory

## Analysis

Undecidable, System

## Applies to

C11

## Amplification

Initialization of atomic objects shall be completed before accessing them:
* For objects that do not have static storage duration, initialization shall be included in their declaration using the assignment operator `=` or using the Standard Library function `atomic_init()`, before any other access.
* For objects of static storage duration, the default initialization is sufficient. 

## Rationale

An atomic object is to be initialized before it is accessed. Concurrent access to the object being initialized, even via an atomic operation, constitutes a data race.

The `atomic_init()` function initializes atomic objects, including any additional state that the implementation might need to carry for the atomic object. However, it does not avoid data races. Because of the potential initialization of the implementation state, `atomic_init()` cannot be replaced by other access functions, e.g. `atomic_store()`. Initialization of atomic objects inside of threads would impose constraints on thread ordering which are hard to ensure or verify. An explicit protection, e.g. by use of a mutex, would make atomicity unnecessary. 

## Example

```c
_Atomic int32_t g_ai1; /* Compliant - default initialization */

void main( void )
{
    _Atomic int32_t ai1 = 22; /* Compliant - directly initialized */
    _Atomic int32_t ai2;
    ai2 = 777; /* Non-compliant - not initialized by atomic_init */
    
    _Atomic int32_t ai3;
    atomic_init( &ai3, 333); /* Compliant - Initialized by atomic_init */
    
    /* ------------ */
    
    _Atomic int32_t ai4;
    thrd_create( &id1, t1, &ai4);
    
    atomic_init( &ai4, 666); /* Non-compliant - Initialized after user-thread T1 is created */
    
    thrd_join ( id1, NULL);
}

int32_t t1( t1_paramtype *ptr )
{
    /* accesses g_ai1, ai1, ai2, ai3, ai4 */
}

```

## See also

Dir 5.1, Rule 1.5, Rule 9.1, Rule 12.6

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
