# Rule 14.1 A loop counter shall not have essentially floating type

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Rationale
When using a floating-point *loop counter*, accumulation of rounding errors may result in a mismatch between the expected and actual number of iterations. This can happen when a loop step that is not a power of the floating-point radix is rounded to a value that can be represented.

Even if a loop with a floating-point *loop counter* appears to behave correctly on one implementation, it may give a different number of iterations on another implementation.

## Example
In the following non-compliant example, the value of `counter` is unlikely to be 1 000 at the end of the loop:

```c
uint32_t counter = 0u;

for ( float f = 0.0f; f < 1.0f; f += 0.001f )
{
  ++counter;
}
```

The following compliant example uses an integer *loop counter* to guarantee 1 000 iterations and uses it to generate `f` for use within the loop:

```c
float f;

for ( uint32_t counter = 0u; counter < 1000u; ++counter )
{
  f = ( float ) counter * 0.001f;
}
```

The following *while* loop is non-compliant because `f` is being used as a *loop counter*:

```c
float f = 0.0f;

while ( f < 1.0f )
{
  f += 0.001f;
}
```

The following *while* loop is compliant because `f` is not being used as a *loop counter*.

```c
float    f;
uint32_t u32a;

f = read_float( );

do
{
  u32a = read_u32 ( );
  /* f does not change in the loop so cannot be a loop counter */
} while ( ( ( float ) u32a - f ) > 10.0f );
```

## See also
Rule 14.2

---

Copyright The MISRA Consortium Limited © [Date - March 2025].