# Rule 14.3 Controlling expressions shall not be invariant

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
This rule applies to:
*   Controlling expressions of *if*, *while*, *for*, *do … while* and *switch* statements;
*   The first operand of the *?:* operator.

## Rationale
If a controlling expression has an invariant value, it is possible that there is a programming error. Any code that cannot be reached due to the presence of an invariant expression may be removed by the compiler. This might have the effect of removing defensive code, for instance, from the executable.

## Exception
1.  The following invariants, that are used to create infinite loops, are permitted:
    a.  `for ( ;; ) { … }`
    b.  `while ( true ) { … }`
    c.  `do { … } while ( true );`
2.  A `do { … } while( false )` loop is permitted.

The literals `0` and `1` may be used in place of the Boolean `false` and `true` in these specific forms.

## Example
```c
s8a = ( u16a < 0u ) ? 0 : 1;    /* Non-compliant - u16a always >= 0 */

if ( u16a <= 0xffffu )
{
                                /* Non-compliant - always true      */
}

if ( 2 > 3 )
{
                                /* Non-compliant - always false     */
}

for ( s8a = 0; s8a < 130; ++s8a )
{
                                /* Non-compliant - always true      */
}

if ( ( s8a < 10 ) && ( s8a > 20 ) )
{
                                /* Non-compliant - always false     */
}

if ( ( s8a < 10 ) || ( s8a > 5 ) )
{
                                /* Non-compliant - always true      */
}

while ( s8a > 10 )
{
  if ( s8a > 5 ) 
  {
                                /* Non-compliant - s8a not volatile */
  }
}

while ( true )
{
                                /* Compliant by exception 1         */
}

do
{
                                /* Non-compliant - not boolean false or literal zero */
} while ( 0u == 1u );

const uint8_t numcyl = 4u;

/*
 * Non-compliant - compiler is permitted to assume that numcyl always
 * has value 4 
 */
if ( numcyl == 4u )
{
}

const volatile uint8_t numcyl_cal = 4u;

/*
 * Compliant - compiler assumes numcyl_cal may be changed by
 * an external method, e.g. automotive calibration tool, even
 * though the program cannot modify its value
 */
if ( numcyl_cal == 4u )
{
}

uint16_t n;    /* 10 <= n <= 100 */
uint16_t sum;

sum = 0;
for ( uint16_t i = ( n - 6u ); i < n; ++i )
{
  sum += i;
}

if ( ( sum % 2u ) == 0u )
{
  /*
   * Non-compliant - sum is the sum of 6 consecutive non-negative
   * integers so must be an odd number. The controlling expression
   * of the if statement will always be false.
   */
}

do 
{
  /* Non-compliant - not covered by exception 2 */
} while ( (s8a < 10) && (s8a > 20) );
```

## See also
Rule 2.1, Rule 14.2

---

Copyright The MISRA Consortium Limited © [Date - March 2025].