# Rule 16.1 All *switch* statements shall be well-formed

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
A *switch* statement shall be considered to be well-formed if it conforms to the subset of C *switch* statements that is specified by the following syntax rules. If a syntax rule given here has the same name as one defined in the C Standard then it replaces the standard version for the scope of the *switch* statement; otherwise, all syntax rules given in the C Standard are unchanged.

**switch-statement:**
&nbsp;&nbsp;&nbsp;&nbsp;**switch (** *switch-expression* **)** **{** *case-label-clause-list* *final-default-clause-list* **}**
&nbsp;&nbsp;&nbsp;&nbsp;**switch (** *switch-expression* **)** **{** *initial-default-clause-list* *case-label-clause-list* **}**

**case-label-clause-list:**
&nbsp;&nbsp;&nbsp;&nbsp;*case-clause-list*
&nbsp;&nbsp;&nbsp;&nbsp;*case-label-clause-list* *case-clause-list*

**case-clause-list:**
&nbsp;&nbsp;&nbsp;&nbsp;*case-label* *switch-clause*
&nbsp;&nbsp;&nbsp;&nbsp;*case-label* *case-clause-list*

**case-label:**
&nbsp;&nbsp;&nbsp;&nbsp;**case** *constant-expression* **:**

**final-default-clause-list:**
&nbsp;&nbsp;&nbsp;&nbsp;**default :** *switch-clause*
&nbsp;&nbsp;&nbsp;&nbsp;*case-label* *final-default-clause-list*

**initial-default-clause-list:**
&nbsp;&nbsp;&nbsp;&nbsp;**default :** *switch-clause*
&nbsp;&nbsp;&nbsp;&nbsp;**default :** *case-clause-list*

**switch-clause:**
&nbsp;&nbsp;&nbsp;&nbsp;*statement-list*opt *switch-clause-terminator* **;**
&nbsp;&nbsp;&nbsp;&nbsp;C90: **{** *declaration-list*opt *statement-list*opt *switch-clause-terminator* **; }**
&nbsp;&nbsp;&nbsp;&nbsp;C99 and later: **{** *block-item-list*opt *switch-clause-terminator* **; }**

**switch-clause-terminator:**
&nbsp;&nbsp;&nbsp;&nbsp;*jump-statement*
&nbsp;&nbsp;&nbsp;&nbsp;*func-call-noreturn* **;**

**func-call-noreturn:**
&nbsp;&nbsp;&nbsp;&nbsp;*postfix-expression* forming a function call to a function declared as non-returning

Except where explicitly permitted by this syntax, the **case** and **default** keywords may not appear anywhere within a *switch* statement body.

*Notes:*
1. some of the restrictions imposed on *switch* statements by this rule are expounded in the rules referenced in the “See also” section. It is therefore possible for code to violate both this rule and one of the more specific rules.
2. the term *switch label* is used within the text of the specific *switch* statement rules to denote either a *case label* or a *default label*.

## Rationale
The syntax for the *switch* statement in C is not particularly rigorous and can allow complex, unstructured behaviour. This and other rules impose a simple and consistent structure on the *switch* statement.

## Example
The remaining rules in this section give examples that are also relevant to this rule.

## See also
Rule 15.3, Rule 16.2, Rule 16.3, Rule 16.4, Rule 16.5, Rule 16.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].