# Rule 18.7 Flexible array members shall not be declared

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Rationale
Flexible array members are most likely to be used in conjunction with dynamic memory allocation which is banned by Dir 4.12 and Rule 21.3.

The presence of flexible array members modifies the behaviour of the *sizeof* operator in ways that might not be expected by a programmer. The assignment of a structure that contains a flexible array member to another structure of the same type may not behave in the expected manner as it copies only those elements up to but not including the start of the flexible array member.

## Example
```c
#include <stdlib.h>

struct s
{
  uint16_t len;
  uint32_t data[ ]; /* Non-compliant - flexible array member */
} str;

struct s *copy ( struct s *s1 )
{
  struct s *s2;

  /* Omit malloc ( ) return check for brevity */
  s2 = malloc ( sizeof ( struct s ) + ( s1->len * sizeof ( uint32_t ) ) );

  *s2 = *s1; /* Only copies s1->len */

  return s2;
}
```

## See also
Dir 4.12, Rule 21.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].