# Rule 20.12 A macro parameter used as an operand to the *#* or *##* operators, which is itself subject to further macro replacement, shall only be used as an operand to these operators

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
A macro parameter that is used as an operand of a *#* or *##* operator is **not** expanded prior to being used. The same parameter appearing elsewhere in the replacement text **is** expanded. If the macro parameter is itself subject to macro replacement, its use in mixed contexts within a macro replacement may not meet developer expectations.

## Example
In the following non-compliant example, the macro parameter `x` is replaced with `AA` which is subject to further macro replacement when not used as the operand of `##`:
```c
#define AA        0xffff
#define BB( x )   ( x ) + wow ## x   /* Non-compliant */

void f ( void )
{
  int32_t wowAA = 0;

  /* Expands as wowAA = ( 0xffff ) + wowAA; */
  wowAA = BB ( AA );
}
```
In the following compliant example, the macro parameter `X` is not subject to further macro replacement:
```c
int32_t speed;
int32_t speed_scale;
int32_t scaled_speed;

#define SCALE( X ) ( ( X ) * X ## _scale )

/* expands to scaled_speed = ( ( speed ) * speed_scale ); */
scaled_speed = SCALE ( speed );
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].