# Rule 21.8 The Standard Library termination functions of `<stdlib.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
The termination functions are *abort*, *exit*, *_Exit* and *quick_exit*.

Identifiers with these names shall not be used and no macro with one of these names shall be expanded.

*Note:* Without the *NDEBUG* macro being defined, the expansion of the *assert* macro results in a call to *abort* (or other implementation-defined termination).

## Rationale
These functions have undefined and implementation-defined behaviours associated with them.

## Example
The use of the *assert* macro without *NDEBUG* defined expands to call *abort()*:
```c
#undef NDEBUG
#include <assert.h>

int main( void )
{
  assert( 0 ); /* Non-compliant - expands to call abort() */
}
```
The use of the *assert* macro with *NDEBUG* defined expands to ((void)0), the *null-statement*:
```c
#define NDEBUG
#include <assert.h>

int main( void )
{
  assert( 0 ); /* Rule does not apply - expands to void-expression */
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].