# Rule 22.11 A thread that was previously either joined or detached shall not be subsequently joined nor detached

## Category
Required

## Analysis
Undecidable, System

## Applies to
C11

## Rationale
Invoking *thrd_detach()* or *thrd_join()* on a thread that has been previously detached or joined is undefined behaviour.

## Example
```c
void main( void )
{
  thrd_t id1, id2, id3, id4;

  thrd_create( &id1, t1, NULL );
  thrd_create( &id2, t2, NULL );
  thrd_create( &id3, t3, NULL );
  thrd_create( &id4, t4, NULL );

  thrd_join ( id1, NULL );   /* Compliant     */
  thrd_join ( id1, NULL );   /* Non-compliant - already joined   */

  thrd_detach( id2 );        /* Compliant     */
  thrd_detach( id2 );        /* Non-compliant - already detached */

  thrd_join ( id3, NULL );   /* Compliant     */
  thrd_detach( id3 );        /* Non-compliant - already joined   */

  thrd_detach( id4 );        /* Compliant     */
  thrd_join ( id4, NULL );   /* Non-compliant - already detached */
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].