# Rule 22.7 The macro *EOF* shall only be compared with the unmodified return value from any Standard Library function capable of returning *EOF*

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
The value returned by any of these functions shall not be subject to any type conversion if it is later compared with the macro *EOF*.

*Note:* indirect type conversions, such as those resulting from pointer type conversions, are included within the scope of this rule.

## Rationale
An *EOF* return value from these functions is used to indicate that a stream is either at end-of-file or that a read or write error has occurred. The *EOF* value may become indistinguishable from a valid character code if the value returned is converted to another type. In such cases, testing the converted value against *EOF* will not reliably identify if the end of the file has been reached or if an error has occurred.

If these conditions are to be identified by comparison with *EOF*, the comparison shall be made before any conversion of the value occurs. Alternatively, the Standard Library functions *feof* and *ferror* may be used to directly check the status of the stream, either before or after the conversion takes place.

## Example
```c
void f1 ( void )
{
  char ch;

  ch = ( char ) getchar ();

  /*
   * The following test is non-compliant. It will not be reliable as the
   * return value is cast to a narrower type before checking for EOF.
   */
  if ( EOF != ( int32_t ) ch )
  {
  }
}
```
The following compliant example shows how *feof()* can be used to check for *EOF* when the return value from *getchar()* has been subjected to type conversion:
```c
void f2 ( void )
{
  char ch;

  ch = ( char ) getchar ();

  if ( !feof ( stdin ) )
  {
  }
}

void f3 ( void )
{
  int32_t i_ch;

  i_ch = getchar ();

  /*
   * The following test is compliant. It will be reliable as the
   * unconverted return value is used when checking for EOF.
   */
  if ( EOF != i_ch )
  {
    char ch;
    ch = ( char ) i_ch;
  }
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].