# Rule 3.2 Line-splicing shall not be used in // comments

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
Line-splicing occurs when the `\` character is immediately followed by a new-line character. If the source file contains multibyte characters, they are converted to the source character set before any splicing occurs.

## Rationale
If the source line containing a `//` comment ends with a `\` character in the source character set, the next line becomes part of the comment. This may result in unintentional removal of code.

## Example
In the following non-compliant example, the physical line containing the *if* keyword is logically part of the previous line and is therefore a comment.

```c
extern bool_t b;

void f ( void )
{
  uint16_t x = 0; // comment \
  if ( b )
  {
    ++x;          /* This is always executed */
  }
}
```

## See also
Dir 4.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].