# Rule 5.4 Macro identifiers shall be distinct

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
This rule requires that, when a macro is being defined, its name be distinct from:
*   The names of the other macros that are currently defined; and
*   The names of their parameters.

It also requires that the names of the parameters of a given macro be distinct from each other but does not require that macro parameters names be distinct across two different macros.

The definition of distinct depends on the implementation and on the edition of the C Standard that is being used:
*   In C90 the **minimum** requirement is that the first 31 characters of *macro identifiers* are significant;
*   In C99 and later the **minimum** requirement is that the first 63 characters of *macro identifiers* are significant.

In practice, implementations may provide greater limits. This rule requires that *macro identifiers* be distinct within the limits imposed by the implementation.

## Rationale
If two *macro identifiers* differ only in non-significant characters, the behaviour is undefined. Since macro parameters are active only during the expansion of their macro, there is no issue with parameters in one macro being confused with parameters in another macro.

If portability is a concern, it would be prudent to apply this rule using the minimum limits specified in the C Standard.

Long *macro identifiers* may impair the readability of code. While many automatic code generation systems produce long *macro identifiers*, there is a good argument for keeping *macro identifier* lengths well below this limit.

Note: In C99 and later, if an extended source character appears in a macro name and that character does not have a corresponding universal character, the C Standard does not specify how many characters it occupies.

## Example
In the following example, the implementation in question supports 31 significant case-sensitive characters in *macro identifiers*.

```c
/*      1234567890123456789012345678901*********    Characters */
#define engine_exhaust_gas_temperature_raw       egt_r
#define engine_exhaust_gas_temperature_scaled    egt_s  /* Non-compliant */

/*      1234567890123456789012345678901*********    Characters */
#define engine_exhaust_gas_temp_raw              egt_r
#define engine_exhaust_gas_temp_scaled           egt_s  /* Compliant     */
```

## See also
Rule 5.1, Rule 5.2, Rule 5.5

---

Copyright The MISRA Consortium Limited © [Date - March 2025].