# Rule 8.19 There should be no external declarations in a source file

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
For the purposes of this rule, the meaning of *source file* excludes *header files*.

An non-defining external declaration of an object or function should only appear at file scope and in a *header file*.

## Rationale
An external declaration in a *source file*, or especially at block scope within a function definition, breaks the modularity and encapsulation of the translation unit. A *header file*, declaring the external interface, should be used instead.

## Example
```c
/* module1.h */
extern int32_t i;   /* Compliant - an external declaration in a header file */

/* module1.c */
#include "module1.h"
int32_t i = 0;      /* Defining declaration */

/* module2.c */
extern int32_t i;   /* Non-compliant - external declaration in a source file */
...
foo( i );           /* Some use of i */

/* module3.c */
#include "module1.h" /* Compliant - external declaration of i in header file */
...
foo( i );           /* Some use of i */
```

An external declaration at block scope is never compliant with this rule:

```c
void uses_externs( void )
{
  extern bool flag;           /* Non-compliant - bringing flag into scope 
                                 without a modular interface */
  extern void worker( flag ); /* Non-compliant - brings worker into scope
                                 without a modular interface */
  
  worker(flag );              /* Doing work across unrelated modules */
}
```

## See also
Rule 8.4, Rule 8.5, Rule 8.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].