# Rule 8.7 Functions and objects should not be defined with external linkage if they are referenced in only one translation unit

## Category
Advisory

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Rationale
Reducing the visibility of an object by giving it internal linkage or defining it at block scope reduces the chance that it might be accessed inadvertently. Similarly, reducing the visibility of a function by giving it internal linkage reduces the chance of it being called inadvertently.

Compliance with this rule also avoids any possibility of confusion between an identifier and an identical identifier in another translation unit or a library.

## Example
```c
/* file.h */
extern void ext_fn1 ( void );   /* Compliant */
extern void ext_fn2 ( void );   /* Non-compliant */

/* file1.c */
#include "file.h"

void ext_fn1 ( void )   /* Compliant - defined in this translation unit,
                           but used externally */
{ 
  /* Function definition */
}

void ext_fn2 ( void )   /* Non-compliant - defined and used only
                           in this translation unit */
{ 
  /* Function definition */
}

void fn_file1 ( void ) 
{
  ext_fn2( );
} 

/* file2.c */
#include "file.h"

void fn_file2 ( void ) 
{
  ext_fn1( );
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].