# Dir 5.3 There shall be no dynamic thread creation

## Category
Required

## Applies to
C11

## Amplification
Thread creation shall only occur in a well-defined program start-up phase.

## Rationale
Uncertainty about the number of threads running at a particular point in time is error prone and reduces analysability. Also the overhead in thread creation and destruction is hard to predict.

Usage of a static thread pool is common practice in operating systems for safety-related systems, e.g. ARINC-653 [33], AUTOSAR [37] and OSEK [44].

## Example
```c
thrd_t id1;
thrd_t id2;

int32_t t1( void *ignore )      /* Thread T1 entry */
{
  ...
  thrd_create( &id2, t2, NULL ); /* Non-compliant, not constrained to start-up */
  ...
}

int32_t t2( void *ignore )      /* Thread T2 entry */
{
  ...
}

void main(void)
{
  thrd_create( &id1, t1, NULL ); /* Compliant */
  ...
}
```

## See also
Dir 4.7

---

Copyright The MISRA Consortium Limited © [Date - March 2025].