# Rule 0–1–4 (Required) A project shall not contain non-volatile POD variables having only one use.

## Rationale
With the exception of volatile variables, variables declared and used only once do not contribute to program computations. A use is either an assignment (explicit initialization) or a reference.
These variables are essentially noise but their presence may indicate that the wrong variable has been used elsewhere. Missing statements contribute to this problem.

## Example
```c
const int16_t x = 19; // Compliant 
const int16_t y = 21; // Non-compliant
void usedonlyonce ( void ) 
{ 
 int16_t once_1 = 42; // Non-compliant 
 int16_t once_2;
 once_2 = x ; // Non-compliant 
}
```
Note that x is compliant as there are two uses, firstly when initialized and secondly when assigned to once_2.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
