# Rule 10–3–3 (Required) A virtual function shall only be overridden by a pure virtual function if it is itself declared as pure virtual.

## Rationale
Re-declaring a function as pure may not meet developer expectations.

## Example
```c
class A 
{ 
public: 
 virtual void foo ( ) = 0; // foo declared pure 
};
class B : public A 
{ 
public: 
 virtual void foo ( ) // foo defined 
 { 
 } 
};
class C: public B 
{ 
public: 
 virtual void foo ( ) = 0; // Non-compliant – foo re-declared pure
};
```
The function foo is introduced as pure (making class A abstract), defined in class B (making class B concrete), then re-declared as pure (making class C abstract). As this may not meet developer expectations, the re-declaration as pure is not allowed.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
