# Rule 14–8–2 (Advisory) The viable function set for a function call should either contain no function specializations, or only contain function specializations.

## Rationale
If a function and a specialization of a function template are deemed equivalent after overload resolution, the non-specialized function will be chosen over the function specialization, which may be inconsistent with developer expectations.

## Exception
This rule does not apply to copy constructors or copy assignment operators.

## Example
```c
void f ( short ); // Example 1 
template <typename T> void f ( T ); // Example 2
void b ( short s ) 
{ 
 f ( s ); // Non-compliant - Calls Example 1 
 f ( s + 1 ); // Non-compliant - Calls Example 2
 f<>( s ); // Compliant - Explicitly calls Example 2 
 f<>( s + 1 ); // Compliant - Explicitly calls Example 2 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
