# Rule 15–3–3 (Required) Handlers of a function-try-block implementation of a class constructor or destructor shall not reference non-static members from this class or its bases.

## Amplification
[Undefined 15.3(10)]

## Rationale
The effect of accessing a non-static member of a class or a base class in the handler (i.e. the catch part) of a function-try-block of a class constructor/destructor is undefined.
For example, if a memory allocation exception is thrown during creation of the object, the object will not exist when the handler attempts to access its members. Conversely, in the destructor, the object may have been successfully destroyed before the exception is handled, so again will not be available to the handler.
By contrast, the lifetime of a static member is greater than that of the object itself, so the static member is guaranteed to exist when the handler accesses it.

## Example
```c
class C 
{ 
public: 
 int32_t x;
 C ( ) 
 try 
 { 
 // Action that may raise an exception 
 }
 catch ( ... ) 
 { 
 if ( 0 == x ) // Non-compliant – x may not exist at this point 
 { 
 // Action dependent on value of x 
 } 
 }
 ~C ( ) 
 try 
 { 
 // Action that may raise an exception 
 }
 catch ( ... ) 
 { 
 if ( 0 == x ) // Non-compliant – x may not exist at this point 
 { 
 // Action dependent on value of x 
 } 
 } 
};
```

## See also
Rule 15–3–1, Rule 15–5–1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
