# Rule 15–5–1 (Required) A class destructor shall not exit with an exception.

## Amplification
[Implementation 15.3(9), 15.5.1(2)]

## Rationale
When an exception is thrown, the call stack is unwound up to the point where the exception is to be handled. The destructors for all automatic objects declared between the point where the exception is thrown and where it is to be handled will be invoked. If one of these destructors exits with an exception, then the program will terminate in an implementation-defined manner.
Note that it is acceptable for a destructor to throw an exception that is handled within the destructor, for example within a try-catch block.

## Example
```c
class C1 
{ 
public: 
 ~C1 ( ) 
 { 
 try 
 { 
 throw ( 42 ); // Compliant - exception will not leave 
 // destructor 
 }
 catch ( int32_t i ) // int handler 
 { 
 // Handle int exception throw by destructor 
 } 
 } 
};
class C2 
{ 
public: 
 ~C2 ( ) 
 { 
 throw ( 42 ); // Non-compliant - destructor exits with an 
 // exception 
 } 
};
void foo ( ) 
{ 
 C2 c; // program terminates when c is destroyed
 throw ( 10 ); 
}
```

## See also
Rule 15–3–1, Rule 15–3–3, Rule 15–5–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
