# Rule 16–0–7 (Required) Undefined macro identifiers shall not be used in #if or #elif preprocessor directives, except as operands to the defined operator.

## Rationale
If an attempt is made to use an identifier in a preprocessor directive, and that identifier has not been defined, the preprocessor will assume the value zero. #ifdef, #ifndef and defined() are provided to test the existence of a macro, and are therefore excluded.

## Example
```c
#if x < 0 // Non-compliant - x assumed to be zero as it is not defined
```
Consideration should be given to the use of a #ifdef test before an identifier is used.
Note that preprocessing identifiers may be defined either by use of #define directives or by options specified at compiler invocation. However, the use of the #define directive is preferred.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
