# Rule 18–0–5 (Required) The unbounded functions of library <cstring> shall not be used.

## Category
Required

## Rationale
[Undefined 5.7]

The strcpy, strcmp, strcat, strchr, strspn, strcspn, strpbrk, strrchr, strstr, strtok and strlen functions
within the <cstring> library can read or write beyond the end of a buffer, resulting in undefined
behaviour.
Ideally, a safe string handling library should be used.

## Example
```cpp
#include <cstring>
void fn ( const char_t * pChar ) 
{ 
 char_t array [ 10 ];
 strcpy ( array, pChar ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
