# Rule 2–10–5 (Advisory) The identifier name of a non-member object or function with static storage duration should not be reused.

## Rationale
Regardless of scope, no identifier with static storage duration should be re-used across any source files in the project. This includes objects or functions with external linkage and any objects or functions with the static storage class specifier.
While the compiler can understand this and is in no way confused, the possibility exists for the developer to incorrectly associate unrelated variables with the same name.

## Example
```c
namespace NS1 
{ 
 static int32_t global = 0; 
}
namespace NS2 
{ 
 void fn ( ) 
 { 
 int32_t global; // Non-compliant 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
