# Rule 2–13–1 (Required) Only those escape sequences that are defined in ISO/IEC 14882:2003 shall be used.

## Amplification
[Undefined 2.13.2(3)]

## Rationale
The use of an undefined escape sequence leads to undefined behaviour.
The defined escape sequences (ISO/IEC 14882:2003 [1] §2.13.2) are:
`\n, \t, \v, \b, \r, \f, \a, \\, \?, \', \", \<Octal Number>, \x<Hexadecimal Number>`

## Example
```c
void fn ( ) 
{ 
 const char_t a[ 2 ] = "\k"; // Non-compliant 
 const char_t b[ 2 ] = "\b"; // Compliant
}
```

## See also
Rule 2–13–2

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
