# Rule 2–7–3 (Advisory) Sections of code should not be “commented out” using C++ comments.

## Rationale
Ideally, comments should only be used to explain aspects of the code that may not be clear from the source code itself. Code that is commented-out may become out of date, which may lead to confusion when maintaining the code.
A more appropriate method of recording the history of changes in source code (e.g. a Source Control System) should be used instead of commenting-out.

## Example
```c
void fn ( int32_t i ) 
{ 
 // ++i; // We want to increment 
 for ( int32_t j = 0 ; j != i ; ++j ) 
 { 
 } 
}
```

## See also
Rule 2–7–2

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
