# Rule 4–5–3 (Required) Expressions with type (plain) char and wchar_t shall not be used as operands to built-in operators other than the assignment operator =, the equality operators == and !=, and the unary & operator.

## Rationale
Manipulation of character data may generate results that are contrary to developer expectations. For example, ISO/IEC 14882:2003 [1] §2.2(3) only requires that the digits “0” to “9” have consecutive numerical values.

## Exception
Exceptionally, the following operators may be used if the associated restriction is observed:
* The binary + operator may be used to add an integral value in the range 0 to 9 to ‘0’;
* The binary – operator may be used to subtract character ‘0’;
* The relational operators <, <=, >, >= may be used to determine if a character (or wide character) represents a digit.

## Example
```c
char_t ch = 't'; // Compliant 
uint8_t v;
if ( ( ch >= 'a' ) && ( ch <= 'z' ) ) // Non-compliant 
{ 
}
if ( ( ch >= '0' ) && ( ch <= '9' ) ) // Compliant by exception 
{ 
 v = ch – '0'; // Compliant by exception 
 v = ch – '1'; // Non-compliant 
}
else 
{ 
 // ... 
} 
ch = '0' + v; // Compliant by exception 
ch = 'A' + v; // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
