# Rule 5–0–21 (Required) Bitwise operators shall only be applied to operands of unsigned underlying type.

## Amplification
[Implementation 5.8(3)]

## Rationale
Bitwise operations (~, <<, <<=, >>, >>=, &, &=, ^, ^=, | and |=) are not normally meaningful on signed integers or enumeration constants. Additionally, an implementation-defined result is obtained if a right shift is applied to a negative value.

## Example
```c
if ( ( uint16_a & int16_b ) == 0x1234U ) // Non-compliant 
if ( ( uint16_a | uint16_b ) == 0x1234U ) // Compliant 
if ( ~int16_a == 0x1234U ) // Non-compliant 
if ( ~uint16_a == 0x1234U ) // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
