# Rule 5–0–3 (Required) A cvalue expression shall not be implicitly converted to a different underlying type.

## Rationale
In order to ensure all operations in an expression are performed in the same underlying type, an expression defined as a cvalue shall not undergo further implicit conversions.

## Example
```c
void f ( ) 
{ 
 int32_t s32; 
 int8_t s8;
 s32 = s8 + s8; // Example 1 – 
 // Non-compliant 
 s32 = static_cast < int32_t > ( s8 ) + s8; // Example 2 - Compliant 
 s32 = s32 + s8; // Example 3 - Compliant 
}
```
In Example 1, the addition operation is performed with an underlying type of int8_t and the result is converted to an underlying type of int32_t.
In Examples 2 and 3, the addition is performed with an underlying type of int32_t and therefore no underlying type conversion is required.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
