# Rule 5–0–5 (Required) There shall be no implicit floating-integral conversions.

## Amplification
[Undefined 4.9(1)]

## Rationale
Conversions from floating point to integral types discard information, and may lead to undefined behaviour if the floating-point value cannot be represented in the integral type.
Conversions from integral types to floating point types may not result in an exact representation, which may not be consistent with developer expectations.

## Example
```c
void f ( ) 
{ 
 float32_t f32; 
 int32_t s32;
 s32 = f32; // Non-compliant 
 f32 = s32; // Non-compliant 
 f32 = static_cast< float32_t > ( s32 ); // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
