# Rule 5–0–9 (Required) An explicit integral conversion shall not change the signedness of the underlying type of a cvalue expression.

## Rationale
A signed to unsigned conversion may lead to an expression having a value inconsistent with developer expectations.

## Example
```c
void f ( ) 
{ 
 int8_t s8; 
 uint8_t u8;
 s8 = static_cast< int8_t >( u8 + u8 ); // Non-compliant 
 s8 = static_cast< int8_t >( u8 ) 
 + static_cast< int8_t >( u8 ); // Compliant 
}
```
In the above example, the expression ( u8 + u8 ) is performed with an underlying type of uint8_t rather than int8_t.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
