# Rule 5–14–1 (Required) The right hand operand of a logical && or || operator shall not contain side effects.

## Rationale
There are some situations in C++ where certain parts of expressions may not be evaluated. If these sub-expressions contain side effects then those side effects may or may not occur, depending on the values of other sub expressions.
The operators which can lead to this problem are && and || where the evaluation of the right hand operand is conditional on the value of the left-hand operand. The conditional evaluation of the right-hand operand of one of the logical operators can easily cause problems if the developer relies on a side effect occurring.

## Example
```c
if ( ishigh && ( x == i++ ) ) // Non-compliant 
... 
if ( ishigh && ( x == f( x ) ) ) // Only acceptable if f(x) is 
 // known to have no side effects
```
The operations that cause side effects are accessing a volatile object, modifying an object, modifying a file, or calling a function that does any of those operations, which cause changes in the state of the execution environment of the calling function.

## See also
Rule 5–2–11
ISO/IEC 14882:2003 [1] §3.2(2), §5.14, §5.15

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
