# Rule 6–2–1 (Required) Assignment operators shall not be used in sub-expressions.

## Rationale
Assignments used in a sub-expression add an additional side effect to that of the full expression, potentially resulting in a value inconsistent with developer expectations. In addition, this helps to avoid getting = and == confused.

## Example
```c
x = y; 
x = y = z; // Non-compliant 
if ( x != 0 ) // Compliant 
{ 
 foo ( ); 
}
bool b1 = x != y; // Compliant 
bool b2; 
b2 = x != y; // Compliant
if ( ( x = y ) != 0 ) // Non-compliant 
{ 
 foo ( ); 
}
if ( x = y ) // Non-compliant 
{ 
 foo ( ); 
}
if ( int16_t i = foo ( ) ) // Compliant 
{ 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
