# Rule 6–6–5 (Required) A function shall have a single point of exit at the end of the function.

## Rationale
This is required by IEC 61508 [12], as part of the requirements for a modular approach.

## Exception
A function implementing a function-try-block is permitted to have multiple points of exit, one for the try block and one for each catch handler.
Throwing an exception that is not caught within the function is not considered a point of exit for this rule.

## Example
```c
void fn ( void ) 
{ 
 if ( ... ) 
 { 
 return; // Non-compliant 
 }
 try 
 { 
 if ( ... ) 
 { 
 throw ( 1 ); // Compliant by exception 
 } 
 }
 catch ( int32_t ) 
 { 
 throw; // Compliant by exception 
 } 
 return; // Non-compliant 
}
void fn2 ( void ) 
{ 
 try 
 { 
 return; // Non-compliant 
 } 
 catch ( ... ) 
 { 
 return; // Non-compliant 
 } 
}
void fn3 ( void ) try 
{ 
 return; // Compliant by exception 
} 
catch ( int32_t ) 
{ 
 return; // Compliant by exception 
} 
catch ( ... ) 
{ 
 return; // Compliant by exception 
}
```

## See also
IEC 61508 [12] Part 3 Table B.9

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
