# Rule 7–3–5 (Required) Multiple declarations for an identifier in the same namespace shall not straddle a using-declaration for that identifier.

## Rationale
The set of identifiers introduced by a using-declaration does not include any declarations that may be added by a subsequent declaration in the namespace. Any subsequent declarations will not be found through the using-declaration, which may not be consistent with developer expectations.

## Example
```c
namespace NS1 
{ 
 void f( uint16_t ); // Example 1 
}
using NS1::f;
namespace NS1 
{ 
 void f( uint32_t ); // Example 2 – Non-compliant 
}
void bar() 
{ 
 f( 0U ); 
}
```
In the above example, moving the using-declaration below the second namespace would result in Example 2 being called, as it is a better match than Example 1.

## See also
ISO/IEC 14882:2003 [1] §7.3.3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
