# Rule 8–4–4 (Required) A function identifier shall either be used to call the function or it shall be preceded by &.

## Rationale
A function identifier can implicitly convert to a pointer to a function. In certain contexts this may result in a well-formed program, but which is contrary to developer expectations. For example, if the developer writes:
```c
if ( f )
```
then it is not clear whether the intent is to test if the address of the function is NULL or if a call to the function f() should be made and the brackets have been unintentionally omitted. The use of the & (address-of) operator will resolve this ambiguity.

## Exception
Passing the function by reference, or assigning it to a reference object is not a violation of this rule.

## Example
```c
extern void f ( void );
if ( 0 == f ) // Non-compliant 
{ 
 // ... 
}
void (*p)( void ) = f; // Non-compliant
if ( 0 == &f ) // Compliant 
{ 
 (f)(); // Compliant as function is called 
}
void (*p)( void ) = &f; // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
